-- Homeschool & Chore Management System
-- Phase 1 MVP Database Schema
-- MariaDB 10.11+

-- =====================================================
-- USERS TABLE (Admin accounts)
-- =====================================================
CREATE TABLE `users` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `username` VARCHAR(50) NOT NULL,
  `password_hash` VARCHAR(255) NOT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default admin user (password: admin123 - CHANGE THIS after first login)
INSERT INTO `users` (`username`, `password_hash`) VALUES 
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi');

-- =====================================================
-- CHILDREN TABLE
-- =====================================================
CREATE TABLE `children` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(100) NOT NULL,
  `photo` VARCHAR(255) DEFAULT NULL COMMENT 'Filename of uploaded photo',
  `color` VARCHAR(7) DEFAULT '#6366f1' COMMENT 'Hex color for UI accents',
  `pin` VARCHAR(4) DEFAULT NULL COMMENT '4-digit PIN, NULL if not required',
  `sort_order` INT UNSIGNED NOT NULL DEFAULT 0,
  `is_archived` TINYINT(1) NOT NULL DEFAULT 0,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_archived_sort` (`is_archived`, `sort_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =====================================================
-- TASKS TABLE (Templates / Master tasks)
-- =====================================================
CREATE TABLE `tasks` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `emoji` VARCHAR(10) DEFAULT NULL COMMENT 'Emoji displayed before title',
  `description` TEXT DEFAULT NULL,
  `type` ENUM('homeschool', 'chore') NOT NULL DEFAULT 'chore',
  `assigned_child_id` INT UNSIGNED DEFAULT NULL COMMENT 'NULL = assigned to all children',
  `recurrence_type` ENUM('none', 'daily', 'weekdays', 'weekly') NOT NULL DEFAULT 'none',
  `recurrence_days` VARCHAR(20) DEFAULT NULL COMMENT 'Comma-separated: 0=Sun,1=Mon,...,6=Sat (e.g., "1,2,3,4,5" for weekdays)',
  `start_date` DATE NOT NULL,
  `end_date` DATE DEFAULT NULL COMMENT 'NULL = no end date',
  `sort_order` INT UNSIGNED NOT NULL DEFAULT 0,
  `is_active` TINYINT(1) NOT NULL DEFAULT 1,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_child` (`assigned_child_id`),
  KEY `idx_active_dates` (`is_active`, `start_date`, `end_date`),
  CONSTRAINT `fk_task_child` FOREIGN KEY (`assigned_child_id`) REFERENCES `children` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =====================================================
-- TASK INSTANCES TABLE (Generated daily tasks)
-- =====================================================
CREATE TABLE `task_instances` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `task_id` INT UNSIGNED NOT NULL,
  `child_id` INT UNSIGNED NOT NULL,
  `due_date` DATE NOT NULL,
  `is_completed` TINYINT(1) NOT NULL DEFAULT 0,
  `completed_at` DATETIME DEFAULT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_unique_instance` (`task_id`, `child_id`, `due_date`),
  KEY `idx_child_date` (`child_id`, `due_date`),
  KEY `idx_due_date` (`due_date`),
  CONSTRAINT `fk_instance_task` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_instance_child` FOREIGN KEY (`child_id`) REFERENCES `children` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =====================================================
-- SETTINGS TABLE (Key-value app settings)
-- =====================================================
CREATE TABLE `settings` (
  `setting_key` VARCHAR(50) NOT NULL,
  `setting_value` TEXT DEFAULT NULL,
  `updated_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`setting_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Default settings
INSERT INTO `settings` (`setting_key`, `setting_value`) VALUES
('app_name', 'Home Tasks'),
('admin_pin', '1234'),
('timezone', 'America/Los_Angeles');
