<?php
/**
 * Cron Job: Generate Task Instances
 * 
 * Run this script daily via cron to create task instances for the day.
 * Example cron entry (run at midnight):
 * 0 0 * * * /usr/bin/php /path/to/homeschool/cron/generate_tasks.php
 * 
 * You can also run it manually or call it from the admin panel.
 */

// Allow running from command line or web
if (php_sapi_name() !== 'cli') {
    // If running from web, you might want to add auth check
    // For now, we'll allow it for testing
}

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

// Generate for today
$today = date('Y-m-d');

echo "Generating task instances for: $today\n";

$count = generate_task_instances_for_date($db, $today);

echo "Created $count task instance(s)\n";

// Optionally generate for tomorrow as well (useful if cron runs at night)
// $tomorrow = date('Y-m-d', strtotime('+1 day'));
// $count2 = generate_task_instances_for_date($db, $tomorrow);
// echo "Created $count2 task instance(s) for tomorrow\n";

echo "Done.\n";
