<?php
/**
 * Homeschool & Chore Management System
 * Configuration File
 */

// =====================================================
// DATABASE CONFIGURATION
// =====================================================
define('DB_HOST', 'localhost');
define('DB_NAME', 'your_database_name');  // Change this
define('DB_USER', 'your_database_user');  // Change this
define('DB_PASS', 'your_database_pass');  // Change this

// =====================================================
// APP CONFIGURATION
// =====================================================
define('APP_NAME', 'Home Tasks');
define('APP_URL', 'https://yourdomain.com/homeschool');  // Change this (no trailing slash)
define('APP_PATH', __DIR__);

// Timezone
date_default_timezone_set('America/Los_Angeles');  // Change to your timezone

// =====================================================
// FILE UPLOAD CONFIGURATION
// =====================================================
define('UPLOAD_PATH', APP_PATH . '/uploads/');
define('UPLOAD_URL', APP_URL . '/uploads/');
define('MAX_UPLOAD_SIZE', 5 * 1024 * 1024);  // 5MB
define('ALLOWED_IMAGE_TYPES', ['image/jpeg', 'image/png', 'image/gif', 'image/webp']);

// =====================================================
// SESSION CONFIGURATION
// =====================================================
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// =====================================================
// DATABASE CONNECTION
// =====================================================
$db = mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if (!$db) {
    die('Database connection failed: ' . mysqli_connect_error());
}

// Set charset
mysqli_set_charset($db, 'utf8mb4');

// =====================================================
// HELPER: Get base URL for assets
// =====================================================
function asset_url($path) {
    return APP_URL . '/assets/' . ltrim($path, '/');
}

// =====================================================
// HELPER: Get upload URL for photos
// =====================================================
function upload_url($filename) {
    if (empty($filename)) {
        return asset_url('img/default-avatar.png');
    }
    return UPLOAD_URL . $filename;
}

// =====================================================
// HELPER: Redirect
// =====================================================
function redirect($path) {
    header('Location: ' . APP_URL . '/' . ltrim($path, '/'));
    exit;
}

// =====================================================
// HELPER: Check if admin is logged in
// =====================================================
function is_admin_logged_in() {
    return isset($_SESSION['admin_id']) && $_SESSION['admin_id'] > 0;
}

// =====================================================
// HELPER: Require admin login
// =====================================================
function require_admin_login() {
    if (!is_admin_logged_in()) {
        redirect('admin/login.php');
    }
}

// =====================================================
// HELPER: CSRF Token generation and validation
// =====================================================
function csrf_token() {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function csrf_field() {
    return '<input type="hidden" name="csrf_token" value="' . csrf_token() . '">';
}

function verify_csrf_token($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

// =====================================================
// HELPER: Sanitize output
// =====================================================
function h($string) {
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8');
}

// =====================================================
// HELPER: Flash messages
// =====================================================
function set_flash($type, $message) {
    $_SESSION['flash'] = ['type' => $type, 'message' => $message];
}

function get_flash() {
    if (isset($_SESSION['flash'])) {
        $flash = $_SESSION['flash'];
        unset($_SESSION['flash']);
        return $flash;
    }
    return null;
}
