<?php
/**
 * API: Complete Task
 * Toggle task instance completion status
 */

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

// Set JSON response header
header('Content-Type: application/json');

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

if (!$input) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Invalid JSON']);
    exit;
}

$instance_id = isset($input['instance_id']) ? (int)$input['instance_id'] : 0;
$is_completed = isset($input['is_completed']) ? (bool)$input['is_completed'] : false;

if ($instance_id <= 0) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Invalid instance ID']);
    exit;
}

// Update the task
$result = toggle_task_completion($db, $instance_id, $is_completed);

if ($result) {
    echo json_encode([
        'success' => true,
        'instance_id' => $instance_id,
        'is_completed' => $is_completed ? 1 : 0
    ]);
} else {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Database error']);
}
