<?php
/**
 * Admin Header Include
 */

require_admin_login();

$current_page = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? h($page_title) . ' - ' : ''; ?>Admin - <?php echo h(APP_NAME); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #f1f5f9;
            min-height: 100vh;
        }
        
        /* ========== ADMIN LAYOUT ========== */
        .admin-wrapper {
            display: flex;
            min-height: 100vh;
        }
        
        /* ========== SIDEBAR ========== */
        .sidebar {
            width: 250px;
            background: #1e293b;
            color: #fff;
            padding: 24px 0;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
        }
        
        .sidebar-brand {
            padding: 0 24px 24px;
            border-bottom: 1px solid #334155;
            margin-bottom: 16px;
        }
        
        .sidebar-brand h1 {
            font-size: 20px;
            color: #fff;
        }
        
        .sidebar-brand span {
            font-size: 12px;
            color: #94a3b8;
        }
        
        .sidebar-nav {
            padding: 0 12px;
        }
        
        .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 16px;
            color: #cbd5e1;
            text-decoration: none;
            border-radius: 8px;
            margin-bottom: 4px;
            transition: all 0.2s;
        }
        
        .nav-link:hover {
            background: #334155;
            color: #fff;
        }
        
        .nav-link.active {
            background: #6366f1;
            color: #fff;
        }
        
        .nav-link svg {
            width: 20px;
            height: 20px;
            stroke: currentColor;
            fill: none;
            stroke-width: 2;
        }
        
        .sidebar-footer {
            padding: 16px 24px;
            margin-top: auto;
            border-top: 1px solid #334155;
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: #1e293b;
        }
        
        .sidebar-footer a {
            color: #94a3b8;
            text-decoration: none;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .sidebar-footer a:hover {
            color: #fff;
        }
        
        /* ========== MAIN CONTENT ========== */
        .main-content {
            flex: 1;
            margin-left: 250px;
            padding: 24px;
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 24px;
        }
        
        .page-header h1 {
            font-size: 28px;
            color: #1e293b;
        }
        
        /* ========== CARDS ========== */
        .card {
            background: #fff;
            border-radius: 12px;
            padding: 24px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            margin-bottom: 24px;
        }
        
        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 16px;
            border-bottom: 1px solid #e2e8f0;
        }
        
        .card-header h2 {
            font-size: 18px;
            color: #1e293b;
        }
        
        /* ========== BUTTONS ========== */
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 20px;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            text-decoration: none;
            border: none;
            transition: all 0.2s;
        }
        
        .btn-primary {
            background: #6366f1;
            color: #fff;
        }
        
        .btn-primary:hover {
            background: #4f46e5;
        }
        
        .btn-secondary {
            background: #e2e8f0;
            color: #475569;
        }
        
        .btn-secondary:hover {
            background: #cbd5e1;
        }
        
        .btn-danger {
            background: #fee2e2;
            color: #dc2626;
        }
        
        .btn-danger:hover {
            background: #fecaca;
        }
        
        .btn-sm {
            padding: 6px 12px;
            font-size: 13px;
        }
        
        .btn svg {
            width: 16px;
            height: 16px;
        }
        
        /* ========== FORMS ========== */
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            font-weight: 500;
            color: #374151;
            margin-bottom: 8px;
        }
        
        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 10px 14px;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            transition: border-color 0.2s;
        }
        
        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: #6366f1;
        }
        
        .form-group small {
            display: block;
            margin-top: 6px;
            color: #64748b;
            font-size: 13px;
        }
        
        .form-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
        }
        
        .form-check {
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .form-check input[type="checkbox"] {
            width: 18px;
            height: 18px;
        }
        
        /* ========== TABLES ========== */
        .table-wrapper {
            overflow-x: auto;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        th, td {
            padding: 12px 16px;
            text-align: left;
            border-bottom: 1px solid #e2e8f0;
        }
        
        th {
            font-weight: 600;
            color: #64748b;
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        td {
            color: #1e293b;
        }
        
        tr:hover {
            background: #f8fafc;
        }
        
        .actions {
            display: flex;
            gap: 8px;
        }
        
        /* ========== BADGES ========== */
        .badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 500;
        }
        
        .badge-homeschool {
            background: #dbeafe;
            color: #1d4ed8;
        }
        
        .badge-chore {
            background: #fef3c7;
            color: #b45309;
        }
        
        .badge-active {
            background: #dcfce7;
            color: #16a34a;
        }
        
        .badge-archived {
            background: #f1f5f9;
            color: #64748b;
        }
        
        /* ========== ALERTS ========== */
        .alert {
            padding: 14px 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        
        .alert-success {
            background: #dcfce7;
            color: #166534;
            border: 1px solid #bbf7d0;
        }
        
        .alert-error {
            background: #fee2e2;
            color: #991b1b;
            border: 1px solid #fecaca;
        }
        
        /* ========== AVATAR DISPLAY ========== */
        .avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid #e2e8f0;
        }
        
        .avatar-lg {
            width: 80px;
            height: 80px;
        }
        
        .color-dot {
            width: 24px;
            height: 24px;
            border-radius: 50%;
            display: inline-block;
            border: 2px solid rgba(0,0,0,0.1);
        }
        
        /* ========== EMPTY STATE ========== */
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #64748b;
        }
        
        .empty-state svg {
            width: 64px;
            height: 64px;
            stroke: #cbd5e1;
            margin-bottom: 16px;
        }
        
        .empty-state h3 {
            color: #1e293b;
            margin-bottom: 8px;
        }
    </style>
</head>
<body>
    <div class="admin-wrapper">
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="sidebar-brand">
                <h1><?php echo h(APP_NAME); ?></h1>
                <span>Admin Panel</span>
            </div>
            
            <nav class="sidebar-nav">
                <a href="<?php echo APP_URL; ?>/admin/" class="nav-link <?php echo $current_page === 'index' ? 'active' : ''; ?>">
                    <svg viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="3" y="3" width="7" height="9"/>
                        <rect x="14" y="3" width="7" height="5"/>
                        <rect x="14" y="12" width="7" height="9"/>
                        <rect x="3" y="16" width="7" height="5"/>
                    </svg>
                    Dashboard
                </a>
                
                <a href="<?php echo APP_URL; ?>/admin/children.php" class="nav-link <?php echo in_array($current_page, ['children', 'child_edit']) ? 'active' : ''; ?>">
                    <svg viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                        <circle cx="9" cy="7" r="4"/>
                        <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                        <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                    </svg>
                    Children
                </a>
                
                <a href="<?php echo APP_URL; ?>/admin/tasks.php" class="nav-link <?php echo in_array($current_page, ['tasks', 'task_edit']) ? 'active' : ''; ?>">
                    <svg viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M9 11l3 3L22 4"/>
                        <path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"/>
                    </svg>
                    Tasks
                </a>
            </nav>
            
            <div class="sidebar-footer">
                <a href="<?php echo APP_URL; ?>/" target="_blank">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6"/>
                        <polyline points="15 3 21 3 21 9"/>
                        <line x1="10" y1="14" x2="21" y2="3"/>
                    </svg>
                    View Dashboard
                </a>
            </div>
        </aside>
        
        <!-- Main Content -->
        <main class="main-content">
            <?php 
            $flash = get_flash();
            if ($flash): 
            ?>
                <div class="alert alert-<?php echo $flash['type'] === 'success' ? 'success' : 'error'; ?>">
                    <?php echo h($flash['message']); ?>
                </div>
            <?php endif; ?>
