# Homeschool & Chore Management System
## Setup Instructions

### 1. Upload Files
Upload the entire `homeschool` folder to your web server via cPanel File Manager.

### 2. Create Database
1. In cPanel, go to **MySQL Databases**
2. Create a new database (e.g., `yourusername_homeschool`)
3. Create a database user and assign it to the database with **All Privileges**

### 3. Import Schema
1. Open **phpMyAdmin**
2. Select your new database
3. Click **Import**
4. Upload `schema.sql`
5. Click **Go**

### 4. Configure App
Edit `config.php` and update:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'yourusername_homeschool');  // Your database name
define('DB_USER', 'yourusername_dbuser');       // Your database user
define('DB_PASS', 'your_password');             // Your database password

define('APP_URL', 'https://yourdomain.com/homeschool');  // Your actual URL
```

### 5. Set Permissions
In cPanel File Manager:
- Right-click `uploads` folder → **Change Permissions** → Set to `755`

### 6. Setup Cron Job (Important!)
In cPanel, go to **Cron Jobs** and add:
- **Common Settings:** Once Per Day (at midnight)
- **Command:** `/usr/local/bin/php /home/yourusername/public_html/homeschool/cron/generate_tasks.php`

This generates daily task instances from your recurring tasks.

### 7. First Login
- Go to: `https://yourdomain.com/homeschool/admin/`
- **Username:** `admin`
- **Password:** `admin123`
- **CHANGE THIS PASSWORD** after first login (edit the `users` table in phpMyAdmin)

### 8. Add App Icons (Optional)
Add these images to `assets/img/`:
- `app-icon.png` (180x180px) - For iOS home screen
- `icon-192.png` (192x192px) - For Android
- `icon-512.png` (512x512px) - For Android

### 9. iPad Setup
On your iPad:
1. Open Safari and go to your app URL
2. Tap the Share button
3. Tap "Add to Home Screen"
4. Name it and tap Add

The app will now open in fullscreen mode like a native app!

---

## Quick Start Guide

1. **Add Children:** Admin → Children → Add Child (upload their photos!)
2. **Add Tasks:** Admin → Tasks → Add Task
3. **Run Cron:** Visit `/cron/generate_tasks.php` once to create today's task instances
4. **Test Dashboard:** Go to main URL and tap a child's photo

---

## File Structure
```
homeschool/
├── config.php           ← Edit database settings here
├── functions.php        ← Core functions
├── index.php            ← Kid dashboard
├── schema.sql           ← Database schema (import this)
├── manifest.json        ← Web app manifest
├── admin/
│   ├── index.php        ← Admin dashboard
│   ├── login.php
│   ├── logout.php
│   ├── children.php
│   ├── child_edit.php
│   ├── tasks.php
│   ├── task_edit.php
│   └── includes/
├── api/
│   └── complete_task.php
├── assets/
│   └── img/
├── cron/
│   └── generate_tasks.php
└── uploads/             ← Child photos stored here
```

---

## Troubleshooting

**Tasks not showing up?**
- Run the cron job manually: visit `/cron/generate_tasks.php`
- Check that tasks have today's date in their date range
- Verify the task is marked as "Active"

**Photos not uploading?**
- Check `uploads` folder permissions (should be 755)
- Verify file size is under 5MB

**Database errors?**
- Double-check credentials in `config.php`
- Ensure database user has full privileges

---

## Default Admin Login
- URL: `/admin/`
- Username: `admin`
- Password: `admin123`

**Change this immediately!**
